﻿local Event = require 'utils.event'
local Token = require 'utils.global_token'

-- code for disable landfill technologie:
Event.add(defines.events.on_player_joined_game, function(event)
    local player = game.players[event.player_index]
        game.forces["player"].technologies["landfill"].enabled = false
				game.forces["player"].technologies["cliff-explosives"].enabled = false
end)

-- code for Enemy Loot chance

local entity_drop_amount = {
    ['small-biter'] = {low = 1, high = 20},
    ['small-spitter'] = {low = 1, high = 20},
    ['medium-biter'] = {low = 20, high = 40},
    ['medium-spitter'] = {low = 20, high = 40},
    ['big-biter'] = {low = 40, high = 60},
    ['big-spitter'] = {low = 40, high = 60},
    ['behemoth-biter'] = {low = 60, high = 100},
    ['behemoth-spitter'] = {low = 60, high = 100}
}

local loot_raffle = {"iron-ore", "copper-ore", "coal", "stone", "landfill", "uranium-ore", "crude-oil-barrel"}

local loot = {
    ['iron'] = {weight = 200, name = 'iron-ore'},
	['copper'] = {weight = 120, name = 'copper-ore'},
	['coal'] = {weight	= 150, name = 'coal'},
	['stone'] = {weight = 50, name = 'stone'},
	['landfill'] = {weight = 20, name = 'landfill'},
	['uranium'] = {weight = 1, name = 'uranium-ore'},
	['oil'] = {weight = 0, name = 'crude-oil-barrel'}
}

-- code turrets, cars and tanks not allowed

local function on_built_entity (event)
	if event.created_entity.name == "artillery-turret" or
		event.created_entity.name == "flamethrower-turret" or
		event.created_entity.name == "laser-turret" or
		event.created_entity.name == "gun-turret" or
		event.created_entity.name == "car" or
    event.created_entity.name == "artillery-wagon" or
		event.created_entity.name == "tank" then
			event.created_entity.die("enemy")
			game.print("Turrets, cars and Tanks are disabled!")
		end
	end

local function randomize ()
	local return_value = nil
	local total_weight = loot['iron'].weight + loot['copper'].weight + loot['coal'].weight + loot['stone'].weight + loot['landfill'].weight + loot['uranium'].weight + loot['oil'].weight
	local rand_value = math.random(0, total_weight)
	if rand_value <  loot['iron'].weight then
		return loot['iron'].name
	elseif rand_value < (loot['iron'].weight + loot['copper'].weight) then
		return loot['copper'].name
	elseif rand_value < (loot['iron'].weight + loot['copper'].weight + loot['coal'].weight) then
		return loot['coal'].name
	elseif rand_value < (loot['iron'].weight + loot['copper'].weight + loot['coal'].weight + loot['stone'].weight) then
		return loot['stone'].name
	elseif rand_value < (loot['iron'].weight + loot['copper'].weight + loot['coal'].weight + loot['stone'].weight + loot['landfill'].weight) then
		return loot['landfill'].name
	elseif rand_value < (loot['iron'].weight + loot['copper'].weight + loot['coal'].weight + loot['stone'].weight + loot['landfill'].weight + loot['uranium'].weight) then
		return loot['uranium'].name
	end
	return loot['oil'].name
end

local function on_entity_died(event)
	local entity = event.entity
	if not entity or not entity.valid then
		return
	end
	local name = entity.name
	local bounds = entity_drop_amount[name]
	if bounds then
		local c = math.random(bounds.low, bounds.high)
		if c > 0 then
			local dropped = randomize()
			game.surfaces[1].spill_item_stack(entity.position,{name = dropped, count = c},true)
		end
	end
end

Event.add(defines.events.on_entity_died, on_entity_died)

local biter_building_inhabitants = {}
biter_building_inhabitants[1] = {{"small-biter",8,16}}
biter_building_inhabitants[2] = {{"small-biter",12,24}}
biter_building_inhabitants[3] = {{"small-biter",8,16},{"medium-biter",1,2}}
biter_building_inhabitants[4] = {{"small-biter",4,8},{"medium-biter",4,8}}
biter_building_inhabitants[5] = {{"small-biter",3,5},{"medium-biter",8,12}}
biter_building_inhabitants[6] = {{"small-biter",3,5},{"medium-biter",5,7},{"big-biter",1,2}}
biter_building_inhabitants[7] = {{"medium-biter",6,8},{"big-biter",3,5}}
biter_building_inhabitants[8] = {{"medium-biter",2,4},{"big-biter",6,8}}
biter_building_inhabitants[9] = {{"medium-biter",2,3},{"big-biter",7,9}}
biter_building_inhabitants[10] = {{"big-biter",4,8},{"behemoth-biter",3,4}}

local function on_entity_died(event)
    if event.entity.name == "biter-spawner" or event.entity.name == "spitter-spawner" then
        local e = math.ceil(game.forces.enemy.evolution_factor*10, 0)
        for _, t in pairs (biter_building_inhabitants[e]) do
            for x = 1, math.random(t[2],t[3]), 1 do
                local p = event.entity.surface.find_non_colliding_position(t[1] , event.entity.position, 6, 1)
                if p then event.entity.surface.create_entity {name=t[1], position=p} end
            end
        end
    end
end


-- code for reading coors ingame: /silent-command game.players[1].print(game.player.selected.position)

-- code for unlocking level 1
local function on_player_rotated_entity(event)
    local surface = game.surfaces[1]
    local tiles = {}
    if not global.trainpath_1 then
        if event.entity.position.x == 445.5 and event.entity.position.y == -189 then
				game.print("Trainpath to rewards of level 1 unlocked!")
        global.trainpath_1 = true
            for x = 3, 34, 1 do
                for y = -3, 188, 1 do
                    table.insert(tiles, {name = "dirt-4", position = {x = event.entity.position.x + x, y = event.entity.position.y + y}})
										for _, player in pairs(game.connected_players) do
											player.play_sound{path="utility/new_objective", volume_modifier=0.3}
										end
                end
            end
            surface.set_tiles(tiles, true)
        end
    end

-- code for unlocking Trainchests at Base
    local surface = game.surfaces[1]
    local tiles = {}
    if not global.trainpath_12 then
        if event.entity.position.x == 442.5 and event.entity.position.y == -189 then
				game.print("Chests with infinite train materials in the base are now unlocked!")
        global.trainpath_12 = true
            for x = 46, 48, 1 do
                for y = 185, 188, 1 do
                    table.insert(tiles, {name = "dirt-1", position = {x = event.entity.position.x + x, y = event.entity.position.y + y}})
										for _, player in pairs(game.connected_players) do
											player.play_sound{path="utility/scenario_message", volume_modifier=0.3}
										end
                end
            end
            surface.set_tiles(tiles, true)
        end
    end

-- code for unlocking level 2
    local surface = game.surfaces[1]
    local tiles = {}
    if not global.trainpath_2 then
        if event.entity.position.x == 445.5 and event.entity.position.y == -413 then
        game.print("Trainpath to rewards of level 2 unlocked!")
        global.trainpath_2 = true
            for x = 3, 34, 1 do
                for y = -3, 188, 1 do
                    table.insert(tiles, {name = "dirt-4", position = {x = event.entity.position.x + x, y = event.entity.position.y + y}})
										for _, player in pairs(game.connected_players) do
											player.play_sound{path="utility/new_objective", volume_modifier=0.3}
										end
                end
            end
            surface.set_tiles(tiles, true)
        end
    end

-- code for unlocking level 3
    local surface = game.surfaces[1]
    local tiles = {}
    if not global.trainpath_3 then
        if event.entity.position.x == 445.5 and event.entity.position.y == -637 then
        game.print("Trainpath to rewards of level 3 unlocked!")
        global.trainpath_3 = true
            for x = 3, 34, 1 do
                for y = -3, 188, 1 do
                    table.insert(tiles, {name = "dirt-4", position = {x = event.entity.position.x + x, y = event.entity.position.y + y}})
										for _, player in pairs(game.connected_players) do
											player.play_sound{path="utility/new_objective", volume_modifier=0.3}
										end
                end
            end
            surface.set_tiles(tiles, true)
        end
    end

-- code for unlocking level 4
    local surface = game.surfaces[1]
    local tiles = {}
    if not global.trainpath_4 then
        if event.entity.position.x == 445.5 and event.entity.position.y == -893 then
        game.print("Trainpath to rewards of level 4 unlocked!")
        global.trainpath_4 = true
            for x = 3, 34, 1 do
                for y = -3, 220, 1 do
                    table.insert(tiles, {name = "dirt-4", position = {x = event.entity.position.x + x, y = event.entity.position.y + y}})
										for _, player in pairs(game.connected_players) do
											player.play_sound{path="utility/new_objective", volume_modifier=0.3}
										end
                end
            end
            surface.set_tiles(tiles, true)
        end
    end

-- code for unlocking level 5
    local surface = game.surfaces[1]
    local tiles = {}
    if not global.trainpath_5 then
        if event.entity.position.x == 445.5 and event.entity.position.y == -1181 then
        game.print("Trainpath to rewards of level 5 unlocked!")
        global.trainpath_5 = true
            for x = 3, 34, 1 do
                for y = -3, 252, 1 do
                    table.insert(tiles, {name = "dirt-4", position = {x = event.entity.position.x + x, y = event.entity.position.y + y}})
										for _, player in pairs(game.connected_players) do
											player.play_sound{path="utility/new_objective", volume_modifier=0.3}
										end
                end
            end
            surface.set_tiles(tiles, true)
        end
    end

-- code for unlocking level 6
    local surface = game.surfaces[1]
    local tiles = {}
    if not global.trainpath_6 then
        if event.entity.position.x == 445.5 and event.entity.position.y == -1469 then
        game.print("Trainpath to rewards of level 6 unlocked!")
        global.trainpath_6 = true
            for x = 3, 34, 1 do
                for y = -3, 252, 1 do
                    table.insert(tiles, {name = "dirt-4", position = {x = event.entity.position.x + x, y = event.entity.position.y + y}})
										for _, player in pairs(game.connected_players) do
											player.play_sound{path="utility/new_objective", volume_modifier=0.3}
										end
                end
            end
            surface.set_tiles(tiles, true)
        end
    end

-- code for unlocking level 7
    local surface = game.surfaces[1]
    local tiles = {}
    if not global.trainpath_7 then
        if event.entity.position.x == 445.5 and event.entity.position.y == -1757 then
        game.print("Trainpath to rewards of level 7 unlocked!")
        global.trainpath_7 = true
            for x = 3, 34, 1 do
                for y = -3, 252, 1 do
                    table.insert(tiles, {name = "dirt-4", position = {x = event.entity.position.x + x, y = event.entity.position.y + y}})
										for _, player in pairs(game.connected_players) do
											player.play_sound{path="utility/new_objective", volume_modifier=0.3}
										end
                end
            end
            surface.set_tiles(tiles, true)
        end
    end

-- code for unlocking level 8
    local surface = game.surfaces[1]
    local tiles = {}
    if not global.trainpath_8 then
        if event.entity.position.x == 445.5 and event.entity.position.y == -2077 then
        game.print("Trainpath to rewards of level 8 unlocked!")
        global.trainpath_8 = true
            for x = 3, 34, 1 do
                for y = -3, 284, 1 do
                    table.insert(tiles, {name = "dirt-4", position = {x = event.entity.position.x + x, y = event.entity.position.y + y}})
										for _, player in pairs(game.connected_players) do
											player.play_sound{path="utility/new_objective", volume_modifier=0.3}
										end
                end
            end
            surface.set_tiles(tiles, true)
        end
    end

-- code for unlocking level 9
    local surface = game.surfaces[1]
    local tiles = {}
    if not global.trainpath_9 then
        if event.entity.position.x == 445.5 and event.entity.position.y == -2429 then
        game.print("Trainpath to rewards of level 9 unlocked!")
        global.trainpath_9 = true
            for x = 3, 34, 1 do
                for y = -3, 316, 1 do
                    table.insert(tiles, {name = "dirt-4", position = {x = event.entity.position.x + x, y = event.entity.position.y + y}})
										for _, player in pairs(game.connected_players) do
											player.play_sound{path="utility/new_objective", volume_modifier=0.3}
										end
                end
            end
            surface.set_tiles(tiles, true)
        end
    end

-- code for unlocking level 10
    local surface = game.surfaces[1]
    local tiles = {}
    if not global.trainpath_10 then
        if event.entity.position.x == 445.5 and event.entity.position.y == -2813 then
        game.print("Trainpath to rewards of level 10 unlocked!")
        global.trainpath_10 = true
            for x = 3, 34, 1 do
                for y = -3, 348, 1 do
                    table.insert(tiles, {name = "dirt-4", position = {x = event.entity.position.x + x, y = event.entity.position.y + y}})
										for _, player in pairs(game.connected_players) do
											player.play_sound{path="utility/new_objective", volume_modifier=0.3}
										end
                end
            end
            surface.set_tiles(tiles, true)
        end
    end

-- code for unlocking level 11
    local surface = game.surfaces[1]
    local tiles = {}
    if not global.trainpath_11 then
        if event.entity.position.x == 445.5 and event.entity.position.y == -3229 then
        game.print("Trainpath to rewards of level 11 unlocked!")
        global.trainpath_11 = true
            for x = 3, 34, 1 do
                for y = -3, 380, 1 do
                    table.insert(tiles, {name = "dirt-4", position = {x = event.entity.position.x + x, y = event.entity.position.y + y}})
										for _, player in pairs(game.connected_players) do
											player.play_sound{path="utility/new_objective", volume_modifier=0.3}
										end
                end
            end
            surface.set_tiles(tiles, true)
        end
    end
end

-- next global.trainpath_13

Event.add(defines.events.on_built_entity, on_built_entity)
Event.add(defines.events.on_entity_died, on_entity_died)
Event.add(defines.events.on_player_rotated_entity, on_player_rotated_entity)
Event.add(defines.events.on_player_joined_game, on_player_joined_game)
